import { useState, useEffect } from 'react'
import { motion, AnimatePresence } from 'framer-motion'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentIndex, setCurrentIndex] = useState(0)
  const images = [
    '/images/slider-1.jpg',
    '/images/slider-2.jpg',
    '/images/slider-3.jpg',
    '/images/slider-4.jpg'
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentIndex((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentIndex((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentIndex(index)
  }

  return (
    <div className="slider-container-tech">
      <div className="slider-wrapper-tech">
        <AnimatePresence mode="wait">
          <motion.div
            key={currentIndex}
            className="slide-tech"
            initial={{ opacity: 0, scale: 0.95 }}
            animate={{ opacity: 1, scale: 1 }}
            exit={{ opacity: 0, scale: 1.05 }}
            transition={{ duration: 0.5 }}
            style={{
              backgroundImage: `url(${images[currentIndex]})`
            }}
          >
            <div className="slide-overlay-tech"></div>
            <div className="slide-grid-tech"></div>
          </motion.div>
        </AnimatePresence>

        <button className="slider-btn-tech slider-btn-prev-tech" onClick={goToPrevious}>
          <ChevronLeft size={24} strokeWidth={2.5} />
        </button>
        <button className="slider-btn-tech slider-btn-next-tech" onClick={goToNext}>
          <ChevronRight size={24} strokeWidth={2.5} />
        </button>

        <div className="slider-dots-tech">
          {images.map((_, index) => (
            <button
              key={index}
              className={`dot-tech ${index === currentIndex ? 'active' : ''}`}
              onClick={() => goToSlide(index)}
            />
          ))}
        </div>
      </div>
    </div>
  )
}

export default ImageSlider

